<?php

namespace Ecomerciar\CruzDelSur\Settings;

use Ecomerciar\CruzDelSur\Settings\Section;
use Ecomerciar\CruzDelSur\Helper\Helper;
use Ecomerciar\CruzDelSur\Settings\Sections\CruzDelSurSection;
use Ecomerciar\CruzDelSur\Settings\Sections\IntegrationSection;
use Ecomerciar\CruzDelSur\Settings\Sections\SellerSection;
use Ecomerciar\CruzDelSur\Sdk\CruzDelSurSdk;

defined('ABSPATH') || exit;

/**
 * A main class that holds all our settings logic
 */
class Main
{
    const VALIDATION_OK_ICON    = '<span class="dashicons dashicons-saved" style="color:green;"></span>';
	const VALIDATION_ERROR_ICON = '<span class="dashicons dashicons-no-alt" style="color:red;"></span>';

    /**
     * Add Cruz del Sur Setting Tab
     *
     * @param Array $settings_tab Shipping Methods
     * @return Array Shipping Methods
     */
    public static function add_tab_settings($settings_tab) {
        $settings_tab['cruzdelsur_shipping_options'] = __('cruzdelsur');
        return $settings_tab;
    }

    /**
     * Get Cruz del Sur Setting Tab
     *
     * @param Array $settings Shipping Methods
     * @param string $current_section Section which is beaing processing
     * @return Array Shipping Method Settings
     */
    public static function get_tab_settings($settings, $current_section) {
        if ('cruzdelsur_shipping_options' == $current_section) {
            add_action( 'admin_footer', ['Ecomerciar\CruzDelSur\Settings\Main', 'enqueue_admin_js'], 10 ); // Priority needs to be higher than wc_print_js (25).
        
            return Section::get();
        }
        else {
            return $settings;
        }
    }

    /**
     * Get Cruz del Sur Settings
     *
     * @return Array Shipping Methods
     */
    public static function get_settings() {
        return apply_filters('wc_settings_cruzdelsur_shipping_options', Section::get());
    }

    /**
     * Update Cruz del Sur Settings
     *
     * @return Void
     */
    public static function update_settings() {
        woocommerce_update_options(self::get_settings());
    }   


    /**
     * enqueue_admin_js
     */
    public static function enqueue_admin_js(){
        wc_enqueue_js(
			"jQuery( function( $ ) {
                            
				function wcPickitSandbox( el ) {
					var form = $( el ).closest( 'form' );
                    var clientid = $( '#wc-cruzdelsur-clientid', form ).closest( 'tr' );
                    var username = $( '#wc-cruzdelsur-username', form ).closest( 'tr' );
                    var password = $( '#wc-cruzdelsur-password', form ).closest( 'tr' );
					var clientidSandbox = $( '#wc-cruzdelsur-clientid_sandbox', form ).closest( 'tr' );
					var usernameSandbox = $( '#wc-cruzdelsur-username_sandbox', form ).closest( 'tr' );
                    var passwordSandbox = $( '#wc-cruzdelsur-password_sandbox', form ).closest( 'tr' );
					if ( 'sandbox' === $( el ).val() ) {
                        clientid.hide();
                        username.hide();
                        password.hide();
                        clientidSandbox.show();
                        usernameSandbox.show();
                        passwordSandbox.show();
                    } else {
                        clientid.show();
                        username.show();
                        password.show();
                        clientidSandbox.hide();
                        usernameSandbox.hide();
                        passwordSandbox.hide();
                    }                    
				}                

				$( document.body ).on( 'change', '#wc-cruzdelsur-environment_mode', function() {
					wcPickitSandbox( this );
				});

				// Change while load.
				$( '#wc-cruzdelsur-environment_mode' ).trigger( 'change' );


			});"
		);
    }
}
