<?php

namespace Ecomerciar\CruzDelSur\Orders;

use Ecomerciar\CruzDelSur\Helper\Helper;
use Ecomerciar\CruzDelSur\Sdk\CruzDelSurSdk;

defined('ABSPATH') || exit;

class TrackingShortcode
{
    /**
     * Handles tracking shortcode html
     *
     * @return string
     */
    public static function output()
    {
        $content = '<h2 class="cruzdelsur-tracking-form-title">Número de envío</h2>
        <form method="get" class="cruzdelsur-tracking-form">
        <input type="text" name="cruzdelsur_tracking_id" style="width:40%" class="cruzdelsur-tracking-form-field"><br>
        <br />
        <input name="submit_button" type="submit"  value="Rastrear"  id="update_button"  class="cruzdelsur-tracking-form-submit update_button" style="cursor: pointer;background-color: #4fa0ff;border: 1px solid #4fa0ff;color: white;padding: 5px 10px;display: inline-block;border-radius: 4px;font-weight: 600;margin-bottom: 10px;text-align: center;"/>
        </form>';
        if (empty($_GET['cruzdelsur_tracking_id'])) {
            return $content;
        }
        $cruzdelsur_id = $_GET['cruzdelsur_tracking_id'];
        $cruzdelsur_id = filter_var($cruzdelsur_id, FILTER_SANITIZE_SPECIAL_CHARS);
        $order_id = Helper::find_order_by_itemmeta_value($cruzdelsur_id);
        $order = wc_get_order($order_id);
        if (empty($order)) {
            $content .= '<h2>Pedido no encontrado</h2>';
            return $content;
        }
        $shipping_methods = $order->get_shipping_methods();
        $shipping_method = array_shift($shipping_methods);
        if ($shipping_method->get_method_id() === 'cruzdelsur') {
            $tracking_number = $shipping_method->get_meta('tracking_number');
            if (empty($tracking_number)) {
                $content .= '<h2>Pedido no encontrado</h2>';
                return $content;
            }
        }
        $cruzdelsurSdk = new CruzDelSurSdk();
        $tracking_statuses = $cruzdelsurSdk->track_order($tracking_number);
        if (!is_array($tracking_statuses)) {
            $content .= '<h3  class="cruzdelsur-tracking-error">Hubo un error, por favor intenta nuevamente</h3>';
        } else {
            if (!empty($tracking_statuses)) {
                $content .= '<h3>Envío Nro: ' . $cruzdelsur_id . '</h3>';
                $content .= "<table>";
                $content .= "<tr>";
                $content .= "<th width=\"30%\">Fecha</th>";
                $content .= "<th width=\"30%\">Sucursal</th>";
                $content .= "<th width=\"40%\">Estado actual</th>";
                $content .= "</tr>";
                foreach ($tracking_statuses as $tracking_status) {
                    $content .= "<tr>";
                    $content .= "<td>" . $tracking_status['Fecha'] . "</td>";
                    $content .= "<td>" . $tracking_status['NombreDeSucursal'] . "</td>";
                    $content .= "<td>" . $tracking_status['Titulo'] . "</td>";
                    $content .= "</tr>";
                }
                $content .= "</table>";
            } else {
                $content .= '<h2>Pedido sin movimientos</h2>';
            }
        }
        return $content;
    }
}
