<?php

namespace Ecomerciar\CruzDelSur\Orders;

use Ecomerciar\CruzDelSur\Helper\Helper;
use Ecomerciar\CruzDelSur\Sdk\CruzDelSurSdk;

defined('ABSPATH') || exit;

class Processor
{
    /**
     * Handles the WooCommerce order status
     *
     * @param int $order_id
     * @param string $status_from
     * @param string $status_to
     * @param WC_Order $order
     * @return void
     */
    public static function handle_order_status(int $order_id, string $status_from, string $status_to, \WC_Order $order)
    {
        $config_status = Helper::get_option('status_processing');
        $config_status = str_replace('wc-', '', $config_status);
        $tmpArray = $order->get_shipping_methods();
        $shipping_method = array_shift($tmpArray);
        if (
            $order->has_status($config_status)
            && $shipping_method->get_method_id() === 'cruzdelsur'
            && empty($shipping_method->get_meta('tracking_number'))
        ) {
            $CdsSdk = new CruzDelSurSdk();
            $res = $CdsSdk->process_order($order, Helper::get_customer_from_order($order));
            if (!$res) {
                Helper::add_error('No se pudo procesar el pedido. Razón: ' . $res['Respuesta'][0]['Descripcion']);
                return;
            }
            $tracking_id = $res['NIC'];
            $shipping_method->update_meta_data('tracking_number', $tracking_id);
            $shipping_method->save();
            
            $order->update_meta_data('tracking_number', $tracking_id);
            $order->save();
            $order->add_order_note(sprintf(__('El pedido fue notificado a Cruz del Sur ( NIC %s ).', 'wc-cruzdelsur') , $tracking_id));            
        }
    }

    /**
     * Process an order in Cruz del Sur, made for AJAX calls
     *
     * @return void
     */
    public static function process_order_ajax()
    {
        if (!wp_verify_nonce($_POST['nonce'], 'wc-cruzdelsur') || empty($_POST['order_id'])) {
            wp_send_json_error();
        }

        $order_id = filter_var($_POST['order_id'], FILTER_SANITIZE_NUMBER_INT);
        $order = wc_get_order($order_id);
        if (!$order) {
            wp_send_json_error();
        }

        $shipping_methods = $order->get_shipping_methods();
        $shipping_method = array_shift($shipping_methods);
        $CdsSdk = new CruzDelSurSdk();
        $res = $CdsSdk->process_order($order, Helper::get_customer_from_order($order));
        if (!$res) {
            wp_send_json_error();
        }
        $tracking_id = $res['NIC'];
        $shipping_method->update_meta_data('tracking_number', $tracking_id);
		$shipping_method->save();
		
        $order->update_meta_data('tracking_number', $tracking_id);
		$order->save();
        wp_send_json_success();
    }
}
