<?php
namespace Ecomerciar\CruzDelSur\Orders;

defined('ABSPATH') || exit;

/**
 * WooCommerce "My Orders" List's Main Class
 */
class Detail {    

    /**
     * Display New fields on Order
     *
     * @param WC_ORDER $order
     */
    public static function display_fields($order) {
        $shipping_methods = $order->get_shipping_methods();
        $shipping_method = array_shift($shipping_methods);

        if ($shipping_method->get_method_id() === 'cruzdelsur') {            
            if (!empty($shipping_method->get_meta('tracking_number'))) {
                ?>
                <div class="woocommerce-order-cruzdelsur container">
                <h2 class="woocommerce-order-cruzdelsur"> <?php esc_html_e('Envío : Cruz Del Sur', 'wc-cruzdelsur'); ?></h2>
                <p><?php echo esc_html($shipping_method->get_method_title());?></p>
                <p>Seguimiento: <?php echo esc_html($shipping_method->get_meta('tracking_number'));?></p>                
                </div>
                <?php         
              }
        }        
    }
}
