<?php

defined('ABSPATH') || exit;

// --- Init Hooks
add_action('admin_notices', ['Ecomerciar\CruzDelSur\Helper\Helper', 'check_notices']);

// --- Settings
add_filter('plugin_action_links_' . plugin_basename(WCCruzDelSur::MAIN_FILE), ['WCCruzDelSur', 'create_settings_link']);
add_filter('woocommerce_get_sections_shipping', ['\Ecomerciar\CruzDelSur\Settings\Main', 'add_tab_settings']);
add_filter('woocommerce_get_settings_shipping', ['\Ecomerciar\CruzDelSur\Settings\Main', 'get_tab_settings'], 10, 2);
add_action('woocommerce_update_options_cruzdelsur_shipping_options', ['\Ecomerciar\CruzDelSur\Settings\Main', 'update_settings']);

// --- Shipment Method
add_filter('woocommerce_shipping_methods', ['WCCruzDelSur', 'add_shipping_method']);

// --- Order section
add_action('woocommerce_order_status_changed', ['\Ecomerciar\CruzDelSur\Orders\Processor', 'handle_order_status'], 10, 4);

if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
    add_action( 'add_meta_boxes_shop_order', ['\Ecomerciar\CruzDelSur\Orders\Metabox', 'create'] );
    add_action( 'add_meta_boxes_woocommerce_page_wc-orders', ['\Ecomerciar\CruzDelSur\Orders\Metabox', 'create'] );
}else{
    add_action('add_meta_boxes', ['\Ecomerciar\CruzDelSur\Orders\Metabox', 'create']);
}

add_action('wp_ajax_process_order', ['\Ecomerciar\CruzDelSur\Orders\Processor', 'process_order_ajax']);

// --- Tracking
add_shortcode('cruzdelsur_tracking_form', ['\Ecomerciar\CruzDelSur\Orders\TrackingShortcode', 'output']);

// --- Tracking - Customer Order Lists
add_filter('woocommerce_my_account_my_orders_columns', ['\Ecomerciar\CruzDelSur\Orders\OrderList', 'add_tracking_column']);
add_action('woocommerce_my_account_my_orders_column_wc-CruzDelSur-tracking', ['\Ecomerciar\CruzDelSur\Orders\OrderList', 'fill_tracking_column']);

// --- View Order Detail
add_filter('woocommerce_order_details_before_order_table', ['\Ecomerciar\CruzDelSur\Orders\Detail', 'display_fields']);