<?php

namespace Ecomerciar\CruzDelSur\Helper;

trait DatabaseTrait
{
    /**
     * Find an order id by itemmeta value
     *
     * @param string $meta_value
     * @return int|false
     */
    public static function find_order_by_itemmeta_value(string $meta_value)
    {
		$args = array(
			'meta_key'      => 'tracking_number', 
			'meta_value'    => $meta_value,  
			'meta_compare'  => '=', 
			'return'        => 'ids'
			);
		
	    $orders = wc_get_orders($args);
		
		// Helper::log_debug( '$order: '. print_r($orders, true) );
		
        if (!empty($orders)) {
            return (int) $orders[0];
        }
		
        return $orders;
        
    }
}
