<?php

namespace Ecomerciar\CruzDelSur\Api;

use Ecomerciar\CruzDelSur\Helper\Helper;


class CruzDelSurApi extends ApiConnector implements ApiInterface
{
    const API_BASE_URL = 'https://api-ventaenlinea.cruzdelsur.com/api';
    const API_BASE_URL_SANDBOX = 'https://api-test.cruzdelsur.com/api';

    public function __construct(string $clientid, string $username, string $password)
    {
        $this->api_config = [
            'idcliente' => $clientid . '_25',
            'ulogin' => $username,
            'uclave' => $password
        ];
    }

    public function get(string $endpoint, array $body = [], array $headers = [])
    {
        $body = array_merge($this->api_config, $body);
        $url = $this->get_base_url() . $endpoint;

        if (!empty($body)) {
            $url .= '?' . http_build_query($body);
        }
        return $this->exec('GET', $url, [], $headers);
    }

    public function get_with_body(string $endpoint, array $args =[], array $body = [], array $headers = [])
    {
        $args = array_merge($this->api_config, $args);
        $url = $this->get_base_url() . $endpoint;

        if (!empty($args)) {
            $url .= '?' . http_build_query($args);
        }
        $headers['Content-Type'] = 'application/json';
        return $this->exec('POST', $url, $body, $headers);
    }

    public function post(string $endpoint, array $body = [], array $headers = [])
    {
        $url = $this->get_base_url() . $endpoint;
        $url = $this->add_params_to_url($url, http_build_query($this->api_config));
        $headers['Content-Type'] = 'application/json';
        return $this->exec('POST', $url, $body, $headers);
    }

    public function put(string $endpoint, array $body = [], array $headers = [])
    {
        $url = $this->get_base_url() . $endpoint;
        $url = $this->add_params_to_url($url, http_build_query($this->api_config));
        $headers['Content-Type'] = 'application/json';
        return $this->exec('PUT', $url, $body, $headers);
    }

    public function delete(string $endpoint, array $body = [], array $headers = [])
    {
        $url = $this->get_base_url() . $endpoint;
        $url = $this->add_params_to_url($url, http_build_query($this->api_config));
        $headers['Content-Type'] = 'application/json';
        return $this->exec('DELETE', $url, $body, $headers);
    }

    public function get_url(string $endpoint, array $params = [])
    {
        $url = $this->get_base_url() . $endpoint;
        $url = $this->add_params_to_url($url, http_build_query($this->api_config));
        if (!empty($params)) {
            $url = $this->add_params_to_url($url, http_build_query($params));
        }
        return $url;
    }

	/**
	 *  Get Base Url
	 *
	 * @return String
	 */
	public function get_base_url() {
		return (Helper::is_sandbox())? $this::API_BASE_URL_SANDBOX : $this::API_BASE_URL;
	}
}