<?php

defined( 'ABSPATH' ) || exit;

$settings = array(
	'title' => [
		'title' => __('Titulo', 'wc-cruzdelsur'),
		'type' => 'text',
		'description' => __('Elige el nombre que verán tus clientes en la sección del checkout', 'wc-cruzdelsur'),
		'default' => __('Cruz del Sur', 'wc-cruzdelsur'),
		'desc_tip'    => true,
	],
	'flat_price' => [
		'title' => __('Habilitar precio fijo?', 'wc-cruzdelsur'),
		'type' => 'checkbox',
		'description' => __('Elige ofrecer envío a un precio fijo a tus clientes', 'wc-cruzdelsur'),
		'desc_tip'    => true,
		'label'=>  __('Activar/Desactivar', 'wc-cruzdelsur'),
	],
	'flat_shipping_price' => [
		'title' => __('Precio Fijio', 'wc-cruzdelsur'),
		'type' => 'number',
		'description' => __('Elige el monto fijo que se cobrará por los envíos.', 'wc-cruzdelsur'),
		'desc_tip'    => true,
	],
	'free_shipping' => [
		'title' => __('Habilitar envío gratis?', 'wc-cruzdelsur'),
		'type' => 'checkbox',
		'description' => __('Elige ofrecer envío gratuito a tus clientes', 'wc-cruzdelsur'),
		'desc_tip'    => true,
		'label'=>  __('Activar/Desactivar', 'wc-cruzdelsur'),
	],
	'free_shipping_from' => [
		'title' => __('Envío gratis desde', 'wc-cruzdelsur'),
		'type' => 'number',
		'description' => __('Elige a partir de que monto se ofrece envío gratuito', 'wc-cruzdelsur'),
		'desc_tip'    => true,
	],
	'shipping_promise' => [
		'title' => __('Habilitar promesa de envío?','wc-cruzdelsur'),
		'type' => 'checkbox',
		'description' => __('Elige informar a tus clientes una promesa de envío', 'wc-cruzdelsur'),
		'desc_tip'    => true,
		'label'=>  __('Activar/Desactivar', 'wc-cruzdelsur'),
	],
	'shipping_promise_day' => [
		'title' => __('Añadir días a Promesa de Envío', 'woocommerce'),
		'type' => 'number',
		'description' => __('Elige la cantidad de días que se añadirán a la promesa de envío', 'wc-cruzdelsur'),
		'desc_tip'    => true
	],
	'shipping_charge' => [
		'title' => __('Habilitar tarifa dinámica?','wc-cruzdelsur'),
		'type'  => 'checkbox',
		'default' => 'no',
		'description' => __('Agrega un porcentaje de descuento o recargo a la tarifa.', 'wc-cruzdelsur'),
		'desc_tip'    => true,
		'label'=>  __('Activar/Desactivar', 'wc-cruzdelsur'),
	],
	'shipping_charge_adj_type' => [
		'title' => __('Quiero aplicar', 'wc-cruzdelsur') ,
		'type' => 'select',  
		'options' => [
		  'CHARGE' => 'Recargo',
		  'DISCOUNT' => 'Descuento'
		]     
	],
	'shipping_charge_adj_pct' => [
	'title' => __('Del %', 'wc-cruzdelsur') ,
	'type' => 'number',
	'default' => 0,
    ],
);

return $settings;
