<?php
namespace Ecomerciar\CruzDelSur\Settings;

use Ecomerciar\CruzDelSur\Helper\Helper;
use Ecomerciar\CruzDelSur\Sdk\CruzDelSurSdk;
/**
 * CruzDelSur Setting Section Main
 */
class Section {

    const VALIDATION_OK_ICON    = '<span class="dashicons dashicons-saved" style="color:green;"></span>';
	const VALIDATION_ERROR_ICON = '<span class="dashicons dashicons-no-alt" style="color:red;"></span>';

    /**
     * Checks system requirements
     *
     * @return Array Fields Settings for Cruz Del Sur
     */
    public static function get() {
       
        //Execute Credential Validations only if page is displayed
        global $current_section;
        if ($current_section ==='cruzdelsur_shipping_options'){
            $credentials_validation = "";
            //Validate Credentials Notice if any data was entered.


            if (Helper::is_sandbox()){
                if(!empty(Helper::get_option('clientid_sandbox', '')) || Helper::get_option('username_sandbox', '') || Helper::get_option('password_sandbox', '')){
                    $CdsSdk = new CruzDelSurSdk();
                    $verify_credentials = $CdsSdk->validate_credentials();
                    if ($verify_credentials===true){
                        $credentials_validation =  self::VALIDATION_OK_ICON . __('Las credenciales ingresadas son correctas!', 'wc-cruzdelsur');
                    } else {
                        $error_message = $verify_credentials;            
                        if (empty($error_message)) {
                            $error_message =  __('Las credenciales ingresadas son incorrectas!', 'wc-cruzdelsur');
                        }
                        $credentials_validation =  self::VALIDATION_ERROR_ICON . $error_message;
                    }
                }   
            } else {
                if(!empty(Helper::get_option('clientid', '')) || Helper::get_option('username', '') || Helper::get_option('password', '')){
                    $CdsSdk = new CruzDelSurSdk();
                    $verify_credentials = $CdsSdk->validate_credentials();
                    if ($verify_credentials===true){
                        $credentials_validation =  self::VALIDATION_OK_ICON . __('Las credenciales ingresadas son correctas!', 'wc-cruzdelsur');
                    } else {
                        $error_message = $verify_credentials;            
                        if (empty($error_message)) {
                            $error_message =  __('Las credenciales ingresadas son incorrectas!', 'wc-cruzdelsur');
                        }
                        $credentials_validation =  self::VALIDATION_ERROR_ICON . $error_message;
                    }
                }   		
            }

   
        } 

        $wc_order_statuses = wc_get_order_statuses();
        $wc_order_statuses["0"] = __('Deshabilitar procesamiento automático', 'wc-cruzdelsur');

        $logo_url = Helper::get_assets_folder_url() . '/img/logo.png';

        $settings = array(
            array(                
                'desc' => sprintf(__('<div style="background-color:#002249;padding: 20px 40px;"><img src="%s" ></div>', 'wc-cruzdelsur'), $logo_url),
                'type' => 'title',
                'id' => 'wc-cruzdelsur_shipping_options',
            ) ,

            array(
                'title' => __('Datos de Cruz del Sur', 'wc-cruzdelsur') ,
                'type'  => 'title',
                'id'    => 'wc-cruzdelsur-data',
            ) ,

            array(
                'title'      => __('Modo de Operación', 'wc-cruzdelsur'),
                'type'      => 'select',
                'default'   => 'sandbox',                   
                'options'   => [
                    'production' => 'Producción',
                    'sandbox'    => 'Sandbox'                        
                ],
                'id' => 'wc-cruzdelsur-environment_mode'
            ) ,

            
                array(
                    'name' => __('Client ID', 'wc-cruzdelsur') ,
                    'type' => 'text',
                    'id' => 'wc-cruzdelsur-clientid'               
                ) ,
                array(
                    'name' => __('Usuario', 'wc-cruzdelsur') ,
                    'type' => 'text',
                    'id' => 'wc-cruzdelsur-username'               
                ) ,
                array(
                    'name' => __('Contraseña', 'wc-cruzdelsur') ,
                    'type' => 'text',
                    'id' => 'wc-cruzdelsur-password'               
                ) ,
                array(
                    'name' => __('Client ID Sandbox', 'wc-cruzdelsur') ,
                    'type' => 'text',
                    'id' => 'wc-cruzdelsur-clientid_sandbox'               
                ) ,
                array(
                    'name' => __('Usuario Sandbox', 'wc-cruzdelsur') ,
                    'type' => 'text',
                    'id' => 'wc-cruzdelsur-username_sandbox'               
                ) ,
                array(
                    'name' => __('Contraseña Sandbox', 'wc-cruzdelsur') ,
                    'type' => 'text',
                    'id' => 'wc-cruzdelsur-password_sandbox'               
                ) ,
                
            array(
                'type' => 'sectionend',
                'id' => 'cruzdelsur-data'
            ) ,

            array(                
                'desc' => sprintf(__('<div>%s</div>', 'wc-cruzdelsur'),  $credentials_validation),
                'type' => 'title',
                'id' => 'wc-cruzdelsur-data-validation',
            ) ,
            array(
                'type' => 'sectionend',
                'id' => 'cruzdelsur-data-validation'
            ) ,

            array(
                'title' => __('Configuración del Remitente', 'wc-cruzdelsur'),
                'type'  => 'title',
                'id'    => 'wc-cruzdelsur-sender',
            ) ,
                array(
                    'name' => __('Nombre', 'wc-cruzdelsur') ,
                    'type' => 'text',
                    'id' => 'wc-cruzdelsur-name'               
                ) ,
                array(
                    'name' => __('Teléfono', 'wc-cruzdelsur') ,
                    'type' => 'text',
                    'id' => 'wc-cruzdelsur-phone'               
                ) ,
                array(
                    'name' => __('Email', 'wc-cruzdelsur') ,
                    'type' => 'text',
                    'id' => 'wc-cruzdelsur-email'               
                ) ,
                array(
                    'name' => __('Dirección del Domicilio', 'wc-cruzdelsur') ,
                    'type' => 'text',
                    'id' => 'wc-cruzdelsur-address'               
                ) ,
                array(
                    'name' => __('Entre Calles (Opcional)', 'wc-cruzdelsur') ,
                    'type' => 'text',
                    'id' => 'wc-cruzdelsur-address_2'               
                ) ,
                array(
                    'name' => __('Localidad', 'wc-cruzdelsur') ,
                    'type' => 'text',
                    'id' => 'wc-cruzdelsur-locality'               
                ) ,
                array(
                    'name' => __('Código Postal', 'wc-cruzdelsur') ,
                    'type' => 'text',
                    'id' => 'wc-cruzdelsur-zipcode'               
                ) ,
                array(
                    'name' => __('Observaciones de la dirección', 'wc-cruzdelsur') ,
                    'type' => 'text',
                    'id' => 'wc-cruzdelsur-observations'               
                ) ,
                array(
                    'name' => __('Hora de apertura 1', 'wc-cruzdelsur') ,
                    'type' => 'select',
                    'id' => 'wc-cruzdelsur-hour1from',
                    'options' => [
                        ''  => __('Seleccionar', 'wc-cruzdelsur'),
                        '8' => '8:00',
                        '9' => '9:00',
                        '10' => '10:00',
                        '11' => '11:00',
                        '12' => '12:00',
                        '13' => '13:00',
                        '14' => '14:00',
                        '15' => '15:00'
                    ] 
                ) ,
                array(
                    'name' => __('Hora de cierre 1', 'wc-cruzdelsur') ,
                    'type' => 'select',
                    'id' => 'wc-cruzdelsur-hour1to',
                    'options' => [
                        ''  => __('Seleccionar', 'wc-cruzdelsur'),
                        '11' => '11:00',
                        '12' => '12:00',
                        '13' => '13:00',
                        '14' => '14:00',
                        '15' => '15:00',
                        '16' => '16:00',
                        '17' => '17:00',
                        '18' => '18:00'
                    ]
                ) ,
                array(
                    'name' => __('Hora de apertura 2 (Opcional)', 'wc-cruzdelsur') ,
                    'type' => 'select',
                    'id' => 'wc-cruzdelsur-hour2from',
                    'options' => [
                        ''  => __('Seleccionar', 'wc-cruzdelsur'),
                        '8' => '8:00',
                        '9' => '9:00',
                        '10' => '10:00',
                        '11' => '11:00',
                        '12' => '12:00',
                        '13' => '13:00',
                        '14' => '14:00',
                        '15' => '15:00'
                    ] 
                ) ,
                array(
                    'name' => __('Hora de cierre 2 (Opcional)', 'wc-cruzdelsur') ,
                    'type' => 'select',
                    'id' => 'wc-cruzdelsur-hour2to',
                    'options' => [
                        ''  => __('Seleccionar', 'wc-cruzdelsur'),
                        '11' => '11:00',
                        '12' => '12:00',
                        '13' => '13:00',
                        '14' => '14:00',
                        '15' => '15:00',
                        '16' => '16:00',
                        '17' => '17:00',
                        '18' => '18:00'
                    ]
                ) ,
                array(
                    'name' => __('Tamaño de hoja', 'wc-cruzdelsur') ,
                    'type' => 'select',
                    'id' => 'wc-cruzdelsur-pagesize',
                    'options' => [
                        '1' => 'A4 (8 Etiquetas por hoja)',
                        '2' => 'Hoja 10x7cm (1 Etiqueta por hoja)'
                    ]
                ) ,            
            array(
                'type' => 'sectionend',
                'id' => 'cruzdelsur-sender'
            ) ,

            array(
                'title' => __('Configuración de la Integración', 'wc-cruzdelsur'),
                'type'  => 'title',
                'id'    => 'wc-cruzdelsur-integration',
            ) ,
                array(
                    'name' => __('Estado de proceso', 'wc-cruzdelsur') ,
                    'desc' => __('Cuando un pedido tenga este estado, será procesado automáticamente a Cruz del Sur.', 'wc-cruzdelsur'),
                    'type' => 'select',
                    'default' => 'wc-completed',
                    'id' => 'wc-cruzdelsur-status_processing',
                    'options' => $wc_order_statuses
                ) ,                     
                array(
                    'name' => __('Modo Debug', 'wc-cruzdelsur') ,
                    'desc' => __('Activa el log de debug para desarrolladores. Si no sabes que es esto probablemente no necesitas activarlo', 'wc-cruzdelsur'),                    
                    'type' => 'select',
                    'default' => '0',
                    'id' => 'wc-cruzdelsur-debug',
                    'options' => [
                        '0' => 'No',
                        '1' => 'Si'
                    ]
                ) ,

            array(
                'type' => 'sectionend',
                'id' => 'cruzdelsur-integration'
            ) ,

            array(
                'title' => __('Rastreo', 'wc-cruzdelsur'),
                'type'  => 'title',
                'id'    => 'wc-cruzdelsur-tracking',
                'desc' => __('Este plugin provee un formulario de rastreo mediante el shortcode <strong>[cruzdelsur_tracking_form]</strong> el cual podés agregar a cualquier página de tu sitio donde querés que aparezca.', 'wc-cruzdelsur'),                
            ) ,
            array(
                'type' => 'sectionend',
                'id' => 'cruzdelsur-tracking'
            ) ,          
        );

        return $settings;
    }

}
