<?php
namespace Ecomerciar\CruzDelSur\Orders;

use Ecomerciar\CruzDelSur\Helper\Helper;
use Ecomerciar\CruzDelSur\Sdk\CruzDelSurSdk;

defined('ABSPATH') || exit;

/**
 * WooCommerce "My Orders" List's Main Class
 */
class OrderList {

    /**
     * Adds new Column for CruzDelSur Tracking Info
     *
     * @return bool
     */
    public static function add_tracking_column($columns) {
        $columns['wc-CruzDelSur-tracking'] = __('Seguimiento CruzDelSur', 'wc-cruzdelsur');
        return $columns;
    }

    /**
     * Adds new Column Info for CruzDelSur Tracking Info
     *
     * @return bool
     */
    public static function fill_tracking_column($order) {
        $shipping_methods = $order->get_shipping_methods();
        $shipping_method = array_shift($shipping_methods);

        if ($shipping_method->get_method_id() === 'cruzdelsur') {            
            if (!empty($shipping_method->get_meta('tracking_number'))) {
                echo "<a href='http://www.cruzdelsur.com/herramientas_seguimiento.php' target='_blank'><span>". esc_html($shipping_method->get_meta('tracking_number')) ."</span></a>";               
              }else {
                echo "<span>".__('Código Seguimiento en Proceso','wc-cruzdelsur')."</span>";

            }
        }
    }

}
