<?php 
namespace Ecomerciar\CruzDelSur\Setup;

use Magento\Framework\DB\Adapter\AdapterInterface;
use Magento\Framework\Setup\SchemaSetupInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\DB\Ddl\Table;

class InstallSchema implements \Magento\Framework\Setup\InstallSchemaInterface
{
    /**
     * Creates plugin's table when plugin is installed
     *
     * @param SchemaSetupInterface $setup
     * @param ModuleContextInterface $context
     * @return void
     */
    public function install(SchemaSetupInterface $setup, ModuleContextInterface $context)
    {
        $setup->startSetup();
        $conn = $setup->getConnection();
        $tableName = $setup->getTable('cruzdelsur_orders');
        if ($conn->isTableExists($tableName) != true) {
            $table = $conn->newTable($tableName)
                ->addColumn(
                    'id',
                    Table::TYPE_INTEGER,
                    null,
                    ['identity' => true, 'unsigned' => true, 'nullable' => false, 'primary' => true]
                )
                ->addColumn(
                    'order_id',
                    Table::TYPE_INTEGER,
                    15,
                    ['nullable' => false, 'unique' => true]
                )
                ->addColumn(
                    'quote_number',
                    Table::TYPE_TEXT,
                    800,
                    ['nullable' => false]
                )
                ->addColumn(
                    'tracking_number',
                    Table::TYPE_TEXT,
                    800,
                    ['nullable' => true, 'default' => null]
                )
                ->addColumn(
                    'meta_value',
                    Table::TYPE_TEXT,
                    800,
                    ['nullable' => false]
                )
                ->addIndex(
                    $setup->getIdxName(
                        'cruzdelsur_order_id',
                        ['order_id'],
                        AdapterInterface::INDEX_TYPE_UNIQUE
                    ),
                    ['order_id'],
                    ['type' => AdapterInterface::INDEX_TYPE_UNIQUE]
                )
                ->setOption('charset', 'utf8');
            $conn->createTable($table);
        }
        $setup->endSetup();
    }
}
?>
