<?php
namespace Ecomerciar\CruzDelSur\Plugin;

/**
 * Class PluginBeforeView
 *
 * @package Ecomerciar\CruzDelSur\Plugin
 */
class PluginBeforeView
{

    /**
     * @var \Ecomerciar\CruzDelSur\Helper\Data
     */
    protected $helper;

    /**
     * @var Ecomerciar\CruzDelSur\Lib\Api
     */
    protected $api;

    /**
     * PluginBeforeView constructor.
     *
     * @param \Ecomerciar\CruzDelSur\Helper\Data $shipmentHelper
     */
    public function __construct(
        \Ecomerciar\CruzDelSur\Helper\Helper $helper,
        \Ecomerciar\CruzDelSur\Lib\Api $api
    ) {
        $this->_helper = $helper;
        $this->_api = $api;
    }

    /**
     * Inserts links to get shipping labels
     * 
     * @param \Magento\Shipping\Block\Adminhtml\View $subject
     * 
     * @return bool|void
     */
    public function beforeGetBackUrl(\Magento\Shipping\Block\Adminhtml\View $subject)
    {
        if ($subject->getRequest()->getFullActionName() !== 'adminhtml_order_shipment_view') return;
        $order = $subject->getShipment()->getOrder();
        $shipping_method = $order->getShippingMethod();
        $shipping_method = explode('|', $shipping_method);
        if ($shipping_method[0] !== 'cruzdelsur_') return;
        $url = $this->_api->get_shipping_label_url($order, 'PDF');
        $subject->addButton(
            'cruzdelsur_shipping_label_pdf_button',
            [
                'label' => 'Ver etiqueta PDF',
                'onclick' => 'window.open(\' ' . $url . '\')',
                'class' => 'go'
            ]
        );
        $url = $this->_api->get_shipping_label_url($order, 'ZPL');
        $subject->addButton(
            'cruzdelsur_shipping_label_zpl_button',
            [
                'label' => 'Ver etiqueta ZPL',
                'onclick' => 'window.open(\' ' . $url . '\')',
                'class' => 'go'
            ]
        );
    }

}