<?php
namespace Ecomerciar\CruzDelSur\Plugin;

/**
 * Class PluginBeforeView
 *
 * @package Ecomerciar\CruzDelSur\Plugin
 */
class CsrfValidatorSkip
{

    /**
     * @param \Magento\Framework\App\Request\CsrfValidator $subject
     * @param \Closure $proceed
     * @param \Magento\Framework\App\RequestInterface $request
     * @param \Magento\Framework\App\ActionInterface $action
     */
    public function aroundValidate(
        $subject,
        \Closure $proceed,
        $request,
        $action
    ) {
        if ($request->getModuleName() === 'cruzdelsurajax')
            return; // Skip CSRF check
        $proceed($request, $action); // Proceed Magento 2 core functionalities
    }
}