<?php
namespace Ecomerciar\CruzDelSur\Observer;

use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Exception\LocalizedException;
use Magento\Sales\Api\OrderRepositoryInterface;

/**
 * Class Shipment
 *
 * @package Ecomerciar\CruzDelSur\Observer
 */
class Shipment implements ObserverInterface
{
    /**
     *
     */
    const CODE = 'CruzDelSur';

    /**
     * @var \Ecomerciar\CruzDelSur\Helper\Helper
     */
    protected $_helper;
    /**
     * @var \Magento\Sales\Model\Order\Shipment\TrackFactory
     */
    protected $_trackFactory;
    /**
     * @var \Ecomerciar\CruzDelSur\Lib\Api
     */
    protected $_api;
    protected $_orderRepository;
    /**
     * Shipment constructor.
     *
     * @param \Ecomerciar\CruzDelSur\Helper\Data           $shipmentHelper
     * @param \Magento\Sales\Model\Order\Shipment              $shipment
     * @param \Magento\Sales\Model\Order\ShipmentFactory       $shipmentFactory
     * @param \Magento\Sales\Model\Order\Shipment\TrackFactory $trackFactory
     * @param \Magento\Framework\DB\Transaction                $transaction
     */
    public function __construct(
        \Magento\Sales\Model\Order\Shipment\TrackFactory $trackFactory,
        \Ecomerciar\CruzDelSur\Helper\Helper $helper,
        \Ecomerciar\CruzDelSur\Lib\Api $api,
        OrderRepositoryInterface $orderRepository
    ) {
        $this->_trackFactory = $trackFactory;
        $this->_helper = $helper;
        $this->_api = $api;
        $this->_orderRepository = $orderRepository;
    }

    /**
     * Processes a Shipment when a Magento Shipment is created
     * 
     * @param \Magento\Framework\Event\Observer $observer
     *
     * @throws \Exception
     * @throws bool
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $shipment = $observer->getEvent()->getShipment();
        $order = $shipment->getOrder();
        $order_id = $order->getId();
        $shipping_method = $order->getShippingMethod();
        $shipping_method = explode('|', $shipping_method);

        
        if ($shipping_method[0] !== 'cruzdelsur_') return false;
        
        $tracking_number = $this->_api->process_order($order);

        if (empty($tracking_number)) {
            $this->_helper->log_error('Se intentó procesar un envío para el pedido: ' . $order->getIncrementId() . ' Pero CDS no devolvió ningún tracking number');
            throw new \Magento\Framework\Exception\LocalizedException(new \Magento\Framework\Phrase('Hubo un error al procesar el envío en Cruz Del Sur'));
        }
        //$this->_helper->db_update_meta(['tracking_number' => $tracking_number], ['order_id' => $order_id]);
        $this->_helper->db_update_meta(['tracking_number' => $tracking_number], ['order_id = ?' => (int)$order_id]);

        $metadata = $this->_helper->db_get_meta($order_id);
        $metadata = unserialize($metadata['meta_value']);
        $track = $this->_trackFactory->create()
            ->setTitle($metadata['full_name'])
            ->setNumber($tracking_number)
            ->setShipment($shipment)
            ->setCarrierCode(\Ecomerciar\CruzDelSur\Model\Carrier\CruzDelSur::CODE)
            ->setOrderId($order_id)
            ->save();
        //$order = $this->_orderRepository->get($order_id);
        //cargar la orden de vuelta y hacer un setstatus y dps save()

    }
}
