<?php
namespace Ecomerciar\CruzDelSur\Observer;

use Magento\Framework\Event\ObserverInterface;

/**
 * Class Shipment
 *
 * @package Ecomerciar\CruzDelSur\Observer
 */
class ProcessOrder implements ObserverInterface
{
    /**
     * @var \Ecomerciar\CruzDelSur\Helper\Helper
     */
    protected $helper;
    /**
     * @var \Magento\Checkout\Model\Session
     */
    protected $checkoutSession;

    /**
     * Constructor
     *
     * @param \Ecomerciar\CruzDelSur\Helper\Helper $helper
     * @param \Magento\Checkout\Model\Session $checkoutSession
     */
    public function __construct(
        \Ecomerciar\CruzDelSur\Helper\Helper $helper,
        \Magento\Checkout\Model\Session $checkoutSession
    ) {
        $this->_helper = $helper;
        $this->_checkoutSession = $checkoutSession;
    }

    /**
     * Saves Shipment extra meta data into the database
     * 
     * @param \Magento\Framework\Event\Observer $observer
     *
     * @throws \Exception
     * @return bool|ProcessOrder
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $order = $observer->getOrder();
        $shipping_method = $order->getShippingMethod();
        $shipping_method = explode('|', $shipping_method);
        if ($shipping_method[0] !== 'cruzdelsur_')
            return $this;
        $index = (int)$shipping_method[1];
        $metadata = $this->_checkoutSession->getCruzDelSurCheckoutMeta();
        $metadata = unserialize($metadata);
        $shipping_title = $order->getShippingDescription();

        $found = false;
        if ('Cruz del Sur - ' . $shipping_title === $metadata[$index]['full_name']) {
            // Our title and api response match
            $selected_method = serialize($metadata[$index]);
            $quote_number = preg_replace('/([0-9]+)-.*/', '$1', $metadata[$index]['id']);
            $found = true;
        } else {
            // Title doesn't match with the api response, this shouldn't happen, so let's find the correct shipping method in our different api response
            foreach ($metadata as $key => $value) {
                if ('Cruz del Sur - ' . $value['full_name'] === $shipping_title) {
                    $found = true;
                    $selected_method = serialize($value);
                    $quote_number = preg_replace('/([0-9]+)-.*/', '$1', $value['id']);
                    break;
                }
            }
        }
        if (!$found) {
            // Incredibly, the api and the shipping method doesn't match, this shouldn't happen ever, we still got a fallback for this
            $selected_method = serialize(['id' => false]);
            $quote_number = false;
        }
        $this->_helper->db_insert_meta([
            'order_id' => $order->getId(),
            'meta_value' => $selected_method,
            'quote_number' => $quote_number,
            'tracking_number' => null
        ]);
        return $this;
    }
}
