<?php

namespace Ecomerciar\CruzDelSur\Model\Carrier;

use Magento\Quote\Model\Quote\Address\RateRequest;

/**
 * Class CruzDelSur
 *
 * @package Ecomerciar\CruzDelSur\Model\Carrier
 */
class CruzDelSur
extends \Magento\Shipping\Model\Carrier\AbstractCarrier
implements \Magento\Shipping\Model\Carrier\CarrierInterface
{

    /**
     * Code of the carrier
     *
     * @var string
     */
    //protected $_code = self::CODE;
    protected $_code = 'cruzdelsur';
    /**
     *
     */
    const CODE = 'cruzdelsur';

    /**
     * @var \Ecomerciar\CruzDelSur\Helper\Helper
     */
    protected $_helper;
    /**
     * @var \Magento\Shipping\Model\Rate\ResultFactory
     */
    protected $_rateResultFactory;
    /**
     * @var \Magento\Quote\Model\Quote\Address\RateResult\MethodFactory
     */
    protected $_rateMethodFactory;
    /**
     * @var \Ecomerciar\CruzDelSur\Lib\Api
     */
    protected $_api;
    /**
     * @var \Magento\Sales\Model\Order\Shipment
     */
    protected $shipmentCollection;
    /**
     * @var \Magento\Sales\Api\OrderRepositoryInterface
     */
    protected $orderRepository;

    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Quote\Model\Quote\Address\RateResult\ErrorFactory $rateErrorFactory,
        \Psr\Log\LoggerInterface $logger,
        \Magento\Shipping\Model\Rate\ResultFactory $rateResultFactory,
        \Magento\Quote\Model\Quote\Address\RateResult\MethodFactory $rateMethodFactory,
        \Magento\Checkout\Model\Session $checkoutSession,
        \Ecomerciar\CruzDelSur\Lib\Api $api,
        \Ecomerciar\CruzDelSur\Helper\Helper $helper,
        \Magento\Sales\Model\Order\Shipment\TrackFactory $trackFactory,
        array $data = []
    ) {
        $this->_rateResultFactory = $rateResultFactory;
        $this->_rateMethodFactory = $rateMethodFactory;
        $this->_helper = $helper;
        $this->_checkoutSession = $checkoutSession;
        $this->_api = $api;
        $this->_trackFactory = $trackFactory;
        parent::__construct($scopeConfig, $rateErrorFactory, $logger, $data);
    }

    /**
     * Get allowed shipping methods
     *
     * @return array
     */
    public function getAllowedMethods()
    {
        return ['cruzdelsur' => 'cruzdelsur'];
    }

    /**
     * Allows magento to apply tracking popup on this method
     *
     * @return true
     */
    public function isTrackingAvailable()
    {
        return true;
    }

    /**
     * Calculates Shipping for a session
     * 
     * @param RateRequest $request
     *
     * @return bool|Result
     */
    public function collectRates(RateRequest $request)
    {
        if (empty($this->_helper->get_config('clientid')) || empty($this->_helper->get_config('username')) || empty($this->_helper->get_config('password'))) return false;
        $result = $this->_rateResultFactory->create();
        $quote = $this->_checkoutSession->getQuote();
        $prices = $this->_api->get_price($quote, $request);
        if (empty($prices)) return $result;

        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        $cart = $objectManager->get('\Magento\Checkout\Model\Cart'); 
        $grandTotal = (float)$cart->getQuote()->getGrandTotal();
        $enviogratisdesde = $this->_helper->get_config('enviogratisdesde');


        $i = 0;
        foreach ($prices as $price) {
            if ($price['price'] == 0 && $i < 1) {
                $method = $this->_rateMethodFactory->create();
                $method_id = '|' . $i;
                $method->setCarrier(self::CODE);
                $method->setCarrierTitle('Cruz del Sur');
                $method->setMethod($method_id);
                $method->setMethodTitle($price['full_name']);
                $method->setPrice("0");
                $result->append($method);
                break;
            } else {
                $method = $this->_rateMethodFactory->create();
                $method_id = '|' . $i;
                $method->setCarrier(self::CODE);
                $method->setCarrierTitle('Cruz del Sur');
                $method->setMethod($method_id);
                $method->setMethodTitle($price['full_name']);
                $method->setPrice($price['price']);
                $result->append($method);
                $i++;
            }
        }
        $this->_checkoutSession->setCruzDelSurCheckoutMeta(serialize($prices));

        return $result;
    }

    /**
     * Gets a tracking info from a tracking number
     *
     * @param string $trackingNumber
     * @return Track
     */
    public function getTrackingInfo($trackingNumber)
    {
        $track = $this->_trackFactory->create();
        $track->setCarrierTitle('Cruz del Sur');
        $track->setTracking($trackingNumber);
        if (empty($trackingNumber)) {
            $track->setErrorMessage('error');
            return $track;
        }
        $tracking_number = $this->_helper->db_get_meta($trackingNumber, 'tracking_number');
        $tracking_number = $tracking_number['tracking_number'];
        $tracking = $this->_api->get_tracking($tracking_number);
        if (is_array($tracking)) {
            $summary = array_pop($tracking);
            $summary = $summary['Titulo'];
        } else {
            $summary = $tracking;
        }
        $track->setTrackSummary($summary);
        //$track->setUrl('https://cruzdelsur.com');
        return $track;
    }
}
