<?php

namespace Ecomerciar\CruzDelSur\Helper;

/**
 * Class CarrierData
 *
 * @package Ecomerciar\CruzDelSur\Helper
 */
class DimensionsHelper
{
    const XML_PATH_ATTRIBUTES_MAPPING = 'carriers/cruzdelsur/attributesmapping';
    const CRUZDELSUR_LENGTH_UNIT = 'cm';
    const CRUZDELSUR_WEIGHT_UNIT = 'gr';

    /**
     * @var array
     */
    protected $_products = [];
    /**
     * @var
     */
    protected $_mapping;
    /**
     * @var \Magento\Catalog\Model\ProductFactory
     */
    protected $_productFactory;
    /**
     * @var \Magento\Checkout\Model\Session
     */
    protected $_checkoutSession;

    /*
     * @var \Magento\Framework\App\Config\ScopeConfigInterface
     */
    protected $scopeConfig;

    /**
     * Constructor
     *
     * @param \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig
     * @param \Magento\Catalog\Model\ProductFactory $productFactory
     */
    public function __construct(
        \Magento\Framework\App\Config\ScopeConfigInterface $scopeConfig,
        \Magento\Catalog\Model\ProductFactory $productFactory
    ) {
        $this->_scopeConfig = $scopeConfig;
        $this->_productFactory = $productFactory;
    }

    /**
     * @param $item
     * @param $type
     *
     * @return float
     */
    public function getShippingDimension($item, $type)
    {

        //$_producto->getResource()
           // ->getAttributeRawValue($_producto->getId(), 'volumen', $_producto->getStoreId())
        $attributeMapped = $this->_getConfigAttributeMapped($type);
        if (!empty($attributeMapped)) {
            if (!isset($this->_products[$item->getProductId()])) {
                $this->_products[$item->getProductId()] = $this->_productFactory->create()->load($item->getProductId());
            }
            $product = $this->_products[$item->getProductId()];
            if ($type === 'volume' && $attributeMapped === 'none') {
                return 0;
            }
            $result = $product->getData($attributeMapped);
            $result = $this->getAttributesMappingUnitConversion($type, $result);

            return $result;
        }
        return 0.00;
    }

    /**
     * @param $type
     *
     * @return null|string
     */
    protected function _getConfigAttributeMapped($type)
    {
        $res = (isset($this->getAttributeMapping()[$type]['code'])) ? $this->getAttributeMapping()[$type]['code'] : null;
        return $res;
    }

    /**
     * @return array
     */
    public function getAttributeMapping()
    {
        if (empty($this->_mapping)) {
            $mapping = $this->_scopeConfig->getValue('carriers/cruzdelsur/attributesmapping');
            $mapping = json_decode($mapping, true);
            $mappingResult = [];
            foreach ($mapping as $key => $map) {
                $mappingResult[$key] = ['code' => $map['attribute_code'], 'unit' => $map['unit']];
            }
            $this->_mapping = $mappingResult;
        }

        return $this->_mapping;
    }

    /**
     * @param $attributeType
     * @param $value
     *
     * @return float
     */
    public function getAttributesMappingUnitConversion($attributeType, $value)
    {
        $this->_getConfigAttributeMapped($attributeType);

        if ($attributeType === 'weight') {
            //check if needs conversion
            if ($this->_mapping[$attributeType]['unit'] != self::CRUZDELSUR_WEIGHT_UNIT) {
                $unit = new \Zend_Measure_Weight((float) $value);
                $unit->convertTo(\Zend_Measure_Weight::KILOGRAM);

                return $unit->getValue();
            }
        } elseif ($this->_mapping[$attributeType]['unit'] != self::CRUZDELSUR_LENGTH_UNIT) {
            $unit = new \Zend_Measure_Length((float) $value);
            $unit->convertTo(\Zend_Measure_Length::CENTIMETER);

            return $unit->getValue();
        }

        return $value;
    }
}
