<?php
namespace Ecomerciar\CruzDelSur\Cron;

use Psr\Log\LoggerInterface;
use Ecomerciar\CruzDelSur\Lib\RestClient;
use Ecomerciar\CruzDelSur\Cron\Shiporder;

class Update {
    protected $logger;

    /**
     * @var \Ecomerciar\CruzDelSur\Lib\Api
     */
    protected $_api;

    /**
     * @var \Ecomerciar\CruzDelSur\Helper\Helper
     */
    protected $_helper;

    /**
     * @var \Ecomerciar\CruzDelSur\Cron\Shiporder
     */
    protected $_shiporder;

    /**
     * @var \Magento\Sales\Api\OrderRepositoryInterface
     */
    protected $orderRepository;
    /**
     * @var \Magento\Framework\Api\SearchCriteriaBuilder
     */
    protected $searchCriteriaBuilder;

    public function __construct(
        LoggerInterface $logger,
        \Ecomerciar\CruzDelSur\Lib\Api $api,
        \Ecomerciar\CruzDelSur\Helper\Helper $helper,
        \Ecomerciar\CruzDelSur\Cron\Shiporder $shiporder,
        \Magento\Sales\Api\OrderRepositoryInterface $orderRepository,
        \Magento\Framework\Api\SearchCriteriaBuilder $searchCriteriaBuilder
    ) {
        $this->logger = $logger;
        $this->_helper = $helper;
        $this->_shiporder = $shiporder;
        $this->_api = $api;
        $this->orderRepository = $orderRepository;
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
    }

   /**
    * Write to system.log
    *
    * @return void
    */
    public function execute() {

    
		 //Start change mapping status
        $searchCriteria = $this->searchCriteriaBuilder
        ->create();

        //If there is a date range to filter...    
        if ($this->_helper->get_config("cantidaddias")) {
            /*** */
            $date = (new \DateTime())->modify('-'.$this->_helper->get_config("cantidaddias").' day');

        $searchCriteria = $this->searchCriteriaBuilder
            ->addFilter(
                'created_at',
                $date->format('Y-m-d'),
                'gt'
            )->create();
            $this->logger->info('Hola'. $date->format('Y-m-d'));
                        
            $orders = $this->orderRepository->getList($searchCriteria);       
        } else {
            $orders = $this->orderRepository->getList($searchCriteria);
        }

        
        
        
        foreach ($orders->getItems() as $getOrder) {

            $this->logger->info('Hola2 '. $date->format('Y-m-d'));
            $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
            $order = $objectManager->create('Magento\Sales\Model\Order')->load($getOrder->getId());
            $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
            $tracksCollection = $order->getTracksCollection();

            //Only filter orders with track number
            foreach ($tracksCollection->getItems() as $track) {
                $trackNumbers = $track->getTrackNumber();

                $getOrderState = $order->getState();
                $getOrderStatus = $order->getStatus();
                $getOrderStaatusFromConfig = explode(",", $this->_helper->get_config("order_status_to_stop"));
                
                //$this->logger->info(print_r($getOrderStaatusFromConfig,true));

                if (in_array($getOrderStatus, $getOrderStaatusFromConfig)) {
                    
                    $this->logger->info('Orden con status: ' . $getOrderStatus . ' no se ejecutará, ORDEN ID '.$getOrder->getId());
                    
                } else {
                    $params = [
                        'idcliente' => $this->_helper->get_config('clientid') . '_23',
                        'nic' => $trackNumbers,
                        'ulogin' => $this->_helper->get_config('username'),
                        'uclave' => $this->_helper->get_config('password')
                    ];
                    $response = RestClient::get("EstadoDelDespachoPorNIC", $params);
                    
                    $mapeo = $this->_helper->get_config('ordermapping');
                    $mapping = json_decode($mapeo, true);
                    $mappingResult = [];
                    $getStatusFromApi = $response['status'];
                    //$this->logger->info(print_r($response,true));
                    
                    if ($getStatusFromApi == "200") {
                        $codigoEstado = $response['response']['Entrega'][0]['Estado'];
                        foreach ($mapping as $key => $map) {
                            if ($codigoEstado == $map['estadocds']) {
                                $order->setState($map['estadomagento'])->setStatus($map['estadomagento']);
            
                                $order->save();
                                $this->logger->info('Se actualizo la orden: ' . $order->getIncrementId() . ' a: '. $map['estadomagento']. "Codigo recibido: ".$codigoEstado);
                    
                            }

                        }
                    }
                }
                
            }
  
            }
        }
   
}
