<?php

namespace Ecomerciar\CruzDelSur\Controller\Widget;

class Track extends \Magento\Framework\App\Action\Action
{
    /**
     * @var \Ecomerciar\CruzDelSur\Helper\Helper
     */
    protected $_helper;
    /**
     * @var \Magento\Framework\Controller\Result\JsonFactory
     */
    protected $_jsonResultFactory;
    /**
     * @var \Magento\Framework\Data\Form\FormKey\Validator
     */
    protected $_formKeyValidator;
    /**
     * @var \Ecomerciar\CruzDelSur\Lib\Api
     */
    protected $_api;

    /**
     *
     * @param \Magento\Framework\App\Action\Context $context
     * @param \Ecomerciar\CruzDelSur\Helper\Helper $helper
     * @param \Magento\Framework\Data\Form\FormKey\Validator $formKeyValidator
     * @param \Ecomerciar\CruzDelSur\Lib\Api $api
     * @param \Magento\Framework\Controller\Result\JsonFactory $jsonResultFactory
     */
    public function __construct(
        \Magento\Framework\App\Action\Context $context,
        \Ecomerciar\CruzDelSur\Helper\Helper $helper,
        \Magento\Framework\Data\Form\FormKey\Validator $formKeyValidator,
        \Ecomerciar\CruzDelSur\Lib\Api $api,
        \Magento\Framework\Controller\Result\JsonFactory $jsonResultFactory
    ) {
        parent::__construct($context);
        $this->_helper = $helper;
        $this->_jsonResultFactory = $jsonResultFactory;
        $this->_formKeyValidator = $formKeyValidator;
        $this->_api = $api;
    }

    /**
     * Handles URL endpoint
     *
     * @return JsonResponse
     */
    public function execute()
    {
        $result = $this->_jsonResultFactory->create();
        $res = $this->_formKeyValidator->validate($this->getRequest());
        if (!$res) {
            $result->setHttpResponseCode(403);
            $result->setData(['error' => 'Hubo un error.']);
        }
        $request = $this->getRequest()->getPost();
        $trackingNumber = filter_var($request->get('cruzdelsur-tracking-id'), FILTER_SANITIZE_STRING);
        $tracking = $this->_api->get_tracking($trackingNumber);
        $result->setHttpResponseCode(200);
        $response = ['response' => $tracking];
        $result->setData($response);
        return $result;
    }
}
