<?php

namespace Ecomerciar\CruzDelSur\Console\Command;

use Psr\Log\LoggerInterface;
use Ecomerciar\CruzDelSur\Lib\RestClient;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Input\InputOption;

class Update extends Command
{
    protected $logger;

    protected $_restclient;

    /**
     * @var \Ecomerciar\CruzDelSur\Lib\Api
     */
    protected $_api;

    /**
     * @var \Ecomerciar\CruzDelSur\Helper\Helper
     */
    protected $_helper;

    /**
     * @var \Magento\Sales\Api\OrderRepositoryInterface
     */
    protected $orderRepository;
    /**
     * @var \Magento\Framework\Api\SearchCriteriaBuilder
     */
    protected $searchCriteriaBuilder;

    protected $_appState;
    public function __construct(
        \Magento\Framework\App\State $appstate,
        LoggerInterface $logger,
        \Ecomerciar\CruzDelSur\Lib\Api $api,
        \Ecomerciar\CruzDelSur\Helper\Helper $helper,

        \Magento\Sales\Api\OrderRepositoryInterface $orderRepository,
        \Magento\Framework\Api\SearchCriteriaBuilder $searchCriteriaBuilder,
        RestClient $restclient
    )
    {
        parent::__construct();
        $this->logger = $logger;
        $this->_helper = $helper;
        $this->_api = $api;
        $this->orderRepository = $orderRepository;
        $this->searchCriteriaBuilder = $searchCriteriaBuilder;
        $this->_appState = $appstate;
        $this->_restclient = $restclient;
    }

    /**
     * Write to system.log
     *
     * @return void
     */
    protected function configure()
    {
        $this->setName('cruzdelsur:shipment:update')
            ->setDescription('update shipments status.')
            ->setDefinition([]);//probar null
        parent::configure();
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->_appState->emulateAreaCode(
            \Magento\Framework\App\Area::AREA_GLOBAL,
            [$this, 'update'],
            [$input, $output]
        );
    }

    public function update(InputInterface $input, OutputInterface $output)
    {
        try {
            //Start change mapping status
            $searchCriteria = $this->searchCriteriaBuilder
                ->create();


            //If there is a date range to filter...
            if ($this->_helper->get_config("cantidaddias")) {
                /*** */
                $date = (new \DateTime())->modify('-' . $this->_helper->get_config("cantidaddias") . ' day');

                $searchCriteria = $this->searchCriteriaBuilder
                    ->addFilter(
                        'created_at',
                        $date->format('Y-m-d'),
                        'gt'
                    )->create();
            }
            $orders = $this->orderRepository->getList($searchCriteria);

            foreach ($orders->getItems() as $getOrder) {
                try {
                    $getOrderStatusShip = $this->_helper->get_config("order_status_ship");
                    $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
                    $order = $objectManager->create('Magento\Sales\Model\Order')->load($getOrder->getId());
                    $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
                    $tracksCollection = $order->getTracksCollection();
                    $this->_helper->log_info('UPDATE :: Entro la orden ' .  $order->getIncrementId());
                    //Only filter orders with track number
                    foreach ($tracksCollection->getItems() as $track) {
                        $trackNumbers = $track->getTrackNumber();

                        $getOrderState = $order->getState();
                        $getOrderStatus = $order->getStatus();
                        $getOrderStatusFromConfig = explode(",", $this->_helper->get_config("order_status_to_stop"));



                        if (in_array($getOrderStatus, $getOrderStatusFromConfig)) {

                            $this->_helper->log_info('Orden con status: ' . $getOrderStatus . ' no se ejecutará, ORDEN ID ' . $getOrder->getId());

                        } else {
                            $params = [
                                'idcliente' => $this->_helper->get_config('clientid') . '_23',
                                'nic' => $trackNumbers,
                                'ulogin' => $this->_helper->get_config('username'),
                                'uclave' => $this->_helper->get_config('password')
                            ];
                            $response = $this->_restclient->get("EstadoDelDespachoPorNIC", $params);

                            $mapeo = $this->_helper->get_config('ordermapping');
                            $mapping = json_decode($mapeo, true);
                            $mappingResult = [];
                            $getStatusFromApi = $response['status'];
                            //$this->logger->info(print_r($response,true));
                            $this->_helper->log_info('Orden en estado '. $order->getStatus() . ' vino el estado: ' . $order->getIncrementId() . ' Mensaje ' .  print_r($response,true));
                            $entro=false;
                            if ($getStatusFromApi == "200") {
                                $codigoEstado = $response['response']['Entrega'][0]['Estado'];
                                foreach ($mapping as $key => $map) {
                                    if ($codigoEstado == $map['estadocds']) {
                                        if( $map['estadomagento'] != $order->getStatus()){
                                        $order->addCommentToStatusHistory('Actualizacion automatico de estado CDS: ' . $map['estadomagento'],$map['estadomagento'],false);
                                        $order->save();
                                        }
                                    }
                                }
                            }
                        }
                    }
                } catch (\Exception $ex) {
                    $this->_helper->log_error('UPDATE :: Error en Orden ' .  $order->getIncrementId()  .' Con el siguiente error:'. $ex->getMessage());
                    $output->writeln('Hubo un error al ejecutar el proceso en la orden : ' . $order->getIncrementId()  . $ex->getMessage());
                }
            }

        } catch (\Exception $ex) {
            $output->writeln('Hubo un error al ejecutar el proceso de UPDATE:  ' . $ex->getMessage());
        }
    }

}
