<?php
namespace Ecomerciar\CruzDelSur\Console\Command;
use Magento\Sales\Api\OrderRepositoryInterface;
use mysql_xdevapi\Exception;
use Psr\Log\LoggerInterface;
use Magento\Framework\Message\ManagerInterface as MessageManagerInterface;
use Magento\Sales\Api\Data\ShipmentExtensionFactory;
use Magento\Sales\Api\Data\ShipmentItemCreationInterface;
use Magento\Sales\Api\Data\ShipmentItemCreationInterfaceFactory;
use Magento\Sales\Model\Order\Shipment\ShipmentValidatorInterface;
use Magento\Sales\Model\Order\Shipment\Validation\QuantityValidator;
use Magento\Sales\Model\Order\ShipmentDocumentFactory;
use Magento\Shipping\Controller\Adminhtml\Order\ShipmentLoader;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Input\InputOption;

Class Shiporder extends Command
{

    protected $_shipOrderInterface;
    protected $_appState;
    protected $_orderRepository;

    /**
     * @var \Ecomerciar\CruzDelSur\Helper\Helper $helper ,
     */
    protected $_helper;

    public function __construct(
        \Magento\Framework\App\State                 $appstate,
        \Ecomerciar\CruzDelSur\Helper\Helper         $helper,
        \Magento\Sales\Api\ShipOrderInterfaceFactory $shipOrderInterface,
        OrderRepositoryInterface                     $orderRepository
    )
    {
        parent::__construct();
        $this->_shipOrderInterface = $shipOrderInterface;
        $this->_helper = $helper;
        $this->_appState = $appstate;
        $this->_orderRepository = $orderRepository;
    }

    protected function configure()
    {
        $this->setName('cruzdelsur:shipment:shiporder')
            ->setDescription('generarte shipments.')
            ->setDefinition([]);//probar null
        parent::configure();
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $this->_appState->emulateAreaCode(
            \Magento\Framework\App\Area::AREA_GLOBAL,
            [$this, 'createShipment'],
            [$input, $output]
        );
    }

    public function createShipment(InputInterface $input, OutputInterface $output)
    {
        try {
            $statuses = $this->_helper->get_config('order_status_to_process');
            $statuses = explode(',', $statuses);
            if (count($statuses) == 0) {
                $output->writeln('No hay estados para recuperar ordenes');
                return;
            }
            $output->writeln('Statuses recuperados' . print_r($statuses, true));
            $cdsOrders = $this->_helper->db_get_meta('', 'tracking_number', 'all', ' is null');
            $output->writeln('ordenes recuperados' . print_r($cdsOrders, true));
            $this->_helper->log_info('ordenes recuperados' . print_r($cdsOrders, true));


            foreach ($cdsOrders as $cdsOrder) {
                $orderId = $cdsOrder['order_id'];
                try {

                    $this->_helper->log_info('SHIP :: voy a shipear esto' . $orderId);
                    $order = $this->_orderRepository->get($orderId);
                    if (in_array($order->getStatus(), $statuses) && $order->canShip()) {

                        $this->_shipOrderInterface->create()->execute($orderId);


                    }
                } catch (\Exception $ex) {
                    $this->_helper->log_error('SHIP :: Error en Orden ' . $orderId . ' Con el siguiente error:' . $ex->getMessage());
                    $output->writeln('Hubo un error al ejecutar el proceso en la orden en SHIP: ' . $orderId . ' Con el siguiente error:' . $ex->getMessage());
                }
            }
        } catch (\Exception $ex) {
            $this->_helper->log_error('SHIP :: Con el siguiente error:' . $ex->getMessage());
            $output->writeln('Hubo un error al ejecutar el proceso SHIP: ' . $ex->getMessage());
        }
    }
}
