<?php
namespace Ecomerciar\CruzDelSur\Block\Adminhtml\System\Config\Fieldset;

use Magento\Config\Block\System\Config\Form\Field\FieldArray\AbstractFieldArray;
use Magento\Framework\DataObject;
use Magento\Framework\Exception\LocalizedException;
use Ecomerciar\CruzDelSur\Block\Adminhtml\Form\Field\OrderStatus;
use Ecomerciar\CruzDelSur\Block\Adminhtml\Form\Field\OrderStatusCds;

/**
 * Class Ranges
 */
class Mappingorder extends AbstractFieldArray
{
    /**
     * @var estadomagentorendered
     */
    private $estadomagentorendered;

     /**
     * @var statemagentorendered
     */
    private $statemagentorendered;

    /**
     * @var estadocdsrendered
     */
    private $estadocdsrendered;

    /**
     * Prepare rendering the new field by adding all the needed columns
     */
    protected function _prepareToRender()
    {
        $this->addColumn('estadomagento', [
            'label' => __('Estado Magento'),
            'renderer' => $this->getEstadoMagentoRendered()
        ]);
        $this->addColumn('estadocds', [
            'label' => __('Estado Cruz Del Sur'),
            'renderer' => $this->getEstadoCdsRendered()
        ]);
        $this->_addAfter = false;
        $this->_addButtonLabel = __('Add');
    }

    /**
     * Prepare existing row data object
     *
     * @param DataObject $row
     * @throws LocalizedException
     */
    protected function _prepareArrayRow(DataObject $row): void
    {
        $options = [];

        $tax = $row->getTax();
        if ($tax !== null) {
            $options['option_' . $this->getTaxRenderer()->calcOptionHash($tax)] = 'selected="selected"';
        }

        $row->setData('option_extra_attrs', $options);
    }

    /**
     * @return OrderStatus
     * @throws LocalizedException
     */
    private function getEstadoMagentoRendered()
    {
        if (!$this->estadomagentorendered) {
            $this->estadomagentorendered = $this->getLayout()->createBlock(
                OrderStatus::class,
                '',
                ['data' => ['is_render_to_js_template' => true]]
            );
        }
        return $this->estadomagentorendered;
    }

    /**
     * @return EstadoCDS
     * @throws LocalizedException
     */
    private function getEstadoCdsRendered()
    {
        if (!$this->estadocdsrendered) {
            $this->estadocdsrendered = $this->getLayout()->createBlock(
                OrderStatusCds::class,
                '',
                ['data' => ['is_render_to_js_template' => true]]
            );
        }
        return $this->estadocdsrendered;
    }
}