<?php

namespace Ecomerciar\CruzDelSur\Block\Adminhtml\System\Config\Fieldset;

/**
 * Class Mapping
 *
 * @package Ecomerciar\CruzDelSur\Block\Adminhtml\System\Config\Fieldset
 */
class Mapping
extends \Magento\Config\Block\System\Config\Form\Field\FieldArray\AbstractFieldArray
{

    /**
     * @var \Magento\Catalog\Model\ResourceModel\Product\Attribute\Collection
     */
    private $attributeCollection;

    /**
     * Constructor
     *
     * @param \Magento\Backend\Block\Template\Context $context
     * @param \Magento\Backend\Model\Auth\Session $authSession
     * @param \Magento\Framework\View\Helper\Js $jsHelper
     * @param \Magento\Catalog\Model\ResourceModel\Product\Attribute\Collection $attributeCollection
     * @param array $data
     */
    public function __construct(
        \Magento\Backend\Block\Template\Context $context,
        \Magento\Backend\Model\Auth\Session $authSession,
        \Magento\Framework\View\Helper\Js $jsHelper,
        \Magento\Catalog\Model\ResourceModel\Product\Attribute\Collection $attributeCollection,
        array $data = []
    ) {
        $this->addColumn('cruzdelsur', array(
            'label' => __('CruzDelSur'),
            'style' => 'width:120px',
        ));
        $this->addColumn('magentoproduct', array(
            'label' => __('Atributo del Producto'),
            'style' => 'width:120px',
        ));

        $this->addColumn('unit', array(
            'label' => __('Unidad del Atributo'),
            'style' => 'width:120px',
        ));

        $this->setTemplate('array_dropdown.phtml');
        $this->attributeCollection = $attributeCollection;

        parent::__construct($context);
    }

    /**
     * Gets all attributes from Magento
     *
     * @return AttributeCollection
     */
    public function _getAttributes()
    {
        $attributes = $this->attributeCollection
            ->addFieldToFilter('is_visible', 1)
            ->addFieldToFilter('frontend_input', ['nin' => ['boolean', 'date', 'datetime', 'gallery', 'image', 'media_image', 'select', 'multiselect', 'textarea']])
            ->load();
        return $attributes;
    }

    /**
     * @return array
     */
    public function _getStoredMappingValues()
    {
        $prevValues = [];
        foreach ($this->getArrayRows() as $key => $_row) {
            $prevValues[$key] = ['attribute_code' => $_row->getData('attribute_code'), 'unit' => $_row->getData('unit')];
        }
        return $prevValues;
    }

    /**
     * @return array
     */
    public function _getCruzDelSurLabel()
    {
        return [__('Longitud'), __('Ancho'), __('Alto'), __('Peso'), __('Volumen (Opcional)')];
    }
}
