<?php
namespace Ecomerciar\CruzDelSur\Block\Adminhtml\Form\Field;

use Magento\Framework\View\Element\Html\Select;

class OrderStatusCds extends Select
{
    /**
     * Set "name" for <select> element
     *
     * @param string $value
     * @return $this
     */
    public function setInputName($value)
    {
        return $this->setName($value);
    }

    /**
     * Set "id" for <select> element
     *
     * @param $value
     * @return $this
     */
    public function setInputId($value)
    {
        return $this->setId($value);
    }

    /**
     * Render block HTML
     *
     * @return string
     */
    public function _toHtml(): string
    {
        if (!$this->getOptions()) {
            $this->setOptions($this->getSourceOptions());
        }
        return parent::_toHtml();
    }

    private function getSourceOptions(): array
    {
        return [
            ['label' => '100 Despacho creado', 'value' => '100'],
            ['label' => '200 Recibido en CDS', 'value' => '200'],
            ['label' => '300 Procesado', 'value' => '300'],
            ['label' => '400 En viaje', 'value' => '400'],
            ['label' => '500 En sucursal', 'value' => '500'],
            ['label' => '600 En reparto', 'value' => '600'],
            ['label' => '700 Entregado', 'value' => '700'],
            ['label' => '800 Con problemas en entrega', 'value' => '800'],
            ['label' => '900 Rechazado', 'value' => '900'],
            ['label' => '1000 Devuelto a origen', 'value' => '1000'],
            ['label' => '1100 Terminado', 'value' => '1100'],

        ];
    }
}